SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OwnerExtractDetales](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[extractID] [int] NULL,
	[extractNo] [int] NULL,
	[WorkType] [nvarchar](900) COLLATE Arabic_CI_AS NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[LastQty] [money] NULL,
	[QtyInPeriod] [money] NULL,
	[NetQty] [money] NULL,
	[Price] [money] NULL,
	[NetValue] [money] NULL,
	[RowID] [int] NULL,
	[CurrentValue] [money] NULL,
	[TaxFactor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxValue] [money] NULL,
	[TotalIncTax] [money] NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MKRPosTableGroup](
	[GrpID] [int] NULL,
	[GrpName] [nvarchar](100) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VocherChecked](
	[voucherID] [int] NULL,
	[VocherName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[VocherDoc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsChecked] [bit] NULL,
	[VocherNo] [int] NULL,
	[VocherBook] [int] NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrPosUser](
	[ID] [int] NOT NULL,
	[PosUserName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CashID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SalesID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RSalesID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DescounID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CashCastID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StockAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SelectedCost] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[MarginClol] [bit] NULL,
	[PriceOut] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ReportName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrinterName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxOrgin] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxType] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ItemType] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PriceIncTax] [bit] NULL,
	[ShowTaxCol] [bit] NULL,
	[PrdPnl] [bit] NULL,
	[PriceOutIndex] [int] NULL,
	[TaxPersent] [money] NULL,
	[chkPOS] [bit] NULL,
	[chkPrd] [bit] NULL,
	[chkSet] [bit] NULL,
	[chkInvoiceSet] [bit] NULL,
	[chkPrdSet] [bit] NULL,
	[chkRsale] [bit] NULL,
	[chkCredt] [bit] NULL,
	[chkDescount] [bit] NULL,
	[chkReprice] [bit] NULL,
	[chkEdit] [bit] NULL,
	[chkMizan] [bit] NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkRestOpt] [bit] NULL,
 CONSTRAINT [PK_MkrPosUser] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_MarginClol]  DEFAULT ((1)) FOR [MarginClol]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_ShowTaxCol]  DEFAULT ((0)) FOR [ShowTaxCol]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkPOS]  DEFAULT ((1)) FOR [chkPOS]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkPrd]  DEFAULT ((1)) FOR [chkPrd]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkSet]  DEFAULT ((1)) FOR [chkSet]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkInvoiceSet]  DEFAULT ((1)) FOR [chkInvoiceSet]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkPrdSet]  DEFAULT ((1)) FOR [chkPrdSet]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkRsale]  DEFAULT ((1)) FOR [chkRsale]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkCredt]  DEFAULT ((1)) FOR [chkCredt]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkDescount]  DEFAULT ((1)) FOR [chkDescount]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkReprice]  DEFAULT ((1)) FOR [chkReprice]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkEdit]  DEFAULT ((1)) FOR [chkEdit]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkMizan]  DEFAULT ((1)) FOR [chkMizan]
ALTER TABLE [dbo].[MkrPosUser] ADD  CONSTRAINT [DF_MkrPosUser_chkRestOpt]  DEFAULT ((1)) FOR [chkRestOpt]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AccNameTemp](
	[AccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[AccRoot] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Tel] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Type] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Balance] [money] NULL,
	[EnName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[BankNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[BankNo1] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Taxno] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccBarcode] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[userBlocked] [nvarchar](500) COLLATE Arabic_CI_AS NULL,
	[UserBalanceBlock] [nvarchar](200) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[FastReportRpt](
	[ID] [int] NULL,
	[IsUseFastReport] [bit] NULL,
	[SalesInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PurchasesInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RSalesInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RPurchasesInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Deliveryvoucher] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TransferMaterials] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[MaterialsInput] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[MaterialsOutput] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StartingBalances] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Quotation] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SalesOrder] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PurchaseOrder] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StockAdjustment] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Production] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[OpeningEntry] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[EntryVoucher] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[JournalFund] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RecCachReceipt] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PayCachReceipt] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RecChkReceipt] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PayChkReceipt] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccountStatement] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ServiceInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ChkAccountStatement] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkList] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccountBalance] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TrialBalance] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AsmTrialBalance] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[FinalAcc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StartChic] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[MatchingBook] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DebitNot] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CreditNot] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CrnPurchases] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CrnSales] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AnalyticalProjects] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SynthesisProjects] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ProjectsResult] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostCenterStatement] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostCenterBalance] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ReceiptMaterials] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SupInvoice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ProjectRec] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Attach1] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Attach2] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Attach3] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Attach4] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Timecard] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrjOwnerInv] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrdRecuest] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_IsUseFastReport]  DEFAULT ((0)) FOR [IsUseFastReport]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_SalesInvoice]  DEFAULT (N'SalesInvoice.frx') FOR [SalesInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PurchasesInvoice]  DEFAULT (N'PurchasesInvoice.frx') FOR [PurchasesInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_SalesInvoice1]  DEFAULT (N'RSalesInvoice.frx') FOR [RSalesInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PurchasesInvoice1]  DEFAULT (N'RPurchasesInvoice.frx') FOR [RPurchasesInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Deliveryvoucher]  DEFAULT (N'Deliveryvoucher.frx') FOR [Deliveryvoucher]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_TransferMaterials]  DEFAULT (N'TransferMaterials.frx') FOR [TransferMaterials]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_MaterialsInput]  DEFAULT (N'MaterialsInput.frx') FOR [MaterialsInput]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_MaterialsInput1]  DEFAULT (N'MaterialsOutput.frx') FOR [MaterialsOutput]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_StartingBalances]  DEFAULT (N'StartingBalances.frx') FOR [StartingBalances]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Quotation]  DEFAULT (N'Quotation.frx') FOR [Quotation]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_SalesOrder]  DEFAULT (N'SalesOrder.frx') FOR [SalesOrder]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PurchaseOrder]  DEFAULT (N'PurchaseOrder.frx') FOR [PurchaseOrder]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_StockAdjustment]  DEFAULT (N'StockAdjustment.frx') FOR [StockAdjustment]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Production]  DEFAULT (N'Production.frx') FOR [Production]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_OpeningEntry]  DEFAULT (N'OpeningEntry.frx') FOR [OpeningEntry]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_EntryVoucher]  DEFAULT (N'EntryVoucher.frx') FOR [EntryVoucher]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_JournalFund]  DEFAULT (N'JournalFund.frx') FOR [JournalFund]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_CatchReceipt]  DEFAULT (N'RecCachReceipt.frx') FOR [RecCachReceipt]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PayCachReceipt]  DEFAULT (N'PayCachReceipt.frx') FOR [PayCachReceipt]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_RecCachReceipt1]  DEFAULT (N'RecChkReceipt.frx') FOR [RecChkReceipt]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PayCachReceipt1]  DEFAULT (N'PayChkReceipt.frx') FOR [PayChkReceipt]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_AccountStatement]  DEFAULT (N'AccountStatement.frx') FOR [AccountStatement]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_ServiceInvoice]  DEFAULT (N'ServiceInvoice.frx') FOR [ServiceInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_AccountStatement1]  DEFAULT (N'ChkAccountStatement.frx') FOR [ChkAccountStatement]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_chkList]  DEFAULT (N'chkList.frx') FOR [chkList]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_AccountBalance]  DEFAULT (N'AccountBalance.frx') FOR [AccountBalance]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_TrialBalance]  DEFAULT (N'TrialBalance.frx') FOR [TrialBalance]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_TrialBalance1]  DEFAULT (N'AsmTrialBalance.frx') FOR [AsmTrialBalance]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_FinalAcc]  DEFAULT (N'FinalAcc.frx') FOR [FinalAcc]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_StartChic]  DEFAULT (N'StartChic.frx') FOR [StartChic]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_MatchingBook]  DEFAULT (N'MatchingBook.frx') FOR [MatchingBook]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_DebitNot]  DEFAULT (N'DebitNot.frx') FOR [DebitNot]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_DebitNot1]  DEFAULT (N'CreditNot.frx') FOR [CreditNot]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_CrnPurchases]  DEFAULT (N'CrnPurchases.frx') FOR [CrnPurchases]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_CrnPurchases1]  DEFAULT (N'CrnSales.frx') FOR [CrnSales]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_AnalyticalProjects]  DEFAULT (N'AnalyticalProjects.frx') FOR [AnalyticalProjects]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_SynthesisProjects]  DEFAULT (N'SynthesisProjects.frx') FOR [SynthesisProjects]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_ProjectsResult]  DEFAULT (N'ProjectsResult.frx') FOR [ProjectsResult]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_CostCenterStatement]  DEFAULT (N'CostCenterStatement.frx') FOR [CostCenterStatement]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_CostCenterStatement1]  DEFAULT (N'CostCenterBalance.frx') FOR [CostCenterBalance]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_ReceiptMaterials]  DEFAULT (N'ReceiptMaterials.frx') FOR [ReceiptMaterials]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_SupInvoice]  DEFAULT (N'SupInvoice.frx') FOR [SupInvoice]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_ProjectRec]  DEFAULT (N'ProjectRec.frx') FOR [ProjectRec]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Attach1]  DEFAULT (N'Attach1.frx') FOR [Attach1]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Attach11]  DEFAULT (N'Attach2.frx') FOR [Attach2]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Attach12]  DEFAULT (N'Attach3.frx') FOR [Attach3]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Attach13]  DEFAULT (N'Attach4.frx') FOR [Attach4]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_Timecard]  DEFAULT (N'Timecard.frx') FOR [Timecard]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PrjOwnerInv]  DEFAULT (N'PrjTaxInvoice.frx') FOR [PrjOwnerInv]
ALTER TABLE [dbo].[FastReportRpt] ADD  CONSTRAINT [DF_FastReportRpt_PrdRecuest]  DEFAULT (N'PrdRecuest.frx') FOR [PrdRecuest]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MKRPosDetales](
	[VoucherNo] [int] NULL,
	[PrdID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Qty] [money] NULL,
	[Price] [money] NULL,
	[Total] [money] NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Tax] [money] NULL,
	[taxPercent] [money] NULL,
	[SelUnitIndex] [int] NULL,
	[IsRowPrint] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MKRPosDetales] ADD  CONSTRAINT [DF_MKRPosDetales_IsRowPrint]  DEFAULT ((0)) FOR [IsRowPrint]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SupContExtractListOption](
	[contSortBy] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ExtractSortBy] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Post] [bit] NULL,
	[UnPost] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[SupContExtractListOption] ADD  CONSTRAINT [DF_SupContExtractListOption_contSortBy]  DEFAULT ((0)) FOR [contSortBy]
ALTER TABLE [dbo].[SupContExtractListOption] ADD  CONSTRAINT [DF_SupContExtractListOption_ExtractSortBy]  DEFAULT ((0)) FOR [ExtractSortBy]
ALTER TABLE [dbo].[SupContExtractListOption] ADD  CONSTRAINT [DF_SupContExtractListOption_Post]  DEFAULT ((1)) FOR [Post]
ALTER TABLE [dbo].[SupContExtractListOption] ADD  CONSTRAINT [DF_SupContExtractListOption_UnPost]  DEFAULT ((1)) FOR [UnPost]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VoucherGenRec](
	[ID] [int] NOT NULL,
	[FormName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[DebitName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[CreditName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[DebitAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CreditAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AplyTax] [bit] NULL,
	[DebitCreditTax] [bit] NULL,
	[AplyCost] [bit] NULL,
	[DebitCredtCost] [bit] NULL,
	[AmountIncTax] [bit] NULL,
	[Prj] [bit] NULL,
	[PrjDebit] [bit] NULL,
	[PrjCredit] [bit] NULL,
 CONSTRAINT [PK_VoucherGenRec] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[VoucherGenRec] ADD  CONSTRAINT [DF_VoucherGenRec_AplyTax]  DEFAULT ((0)) FOR [AplyTax]
ALTER TABLE [dbo].[VoucherGenRec] ADD  CONSTRAINT [DF_VoucherGenRec_DebitCreditTax]  DEFAULT ((0)) FOR [DebitCreditTax]
ALTER TABLE [dbo].[VoucherGenRec] ADD  CONSTRAINT [DF_VoucherGenRec_AplyCost]  DEFAULT ((0)) FOR [AplyCost]
ALTER TABLE [dbo].[VoucherGenRec] ADD  CONSTRAINT [DF_VoucherGenRec_DebitCredtCost]  DEFAULT ((0)) FOR [DebitCredtCost]
ALTER TABLE [dbo].[VoucherGenRec] ADD  CONSTRAINT [DF_VoucherGenRec_AmountIncTax]  DEFAULT ((0)) FOR [AmountIncTax]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OwnerCotractNo](
	[ContID] [int] NOT NULL,
	[ContNo] [int] NULL,
	[ContractorID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[HajezID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrj] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[IncomeAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtWorType] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtRemarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[dtpContDate] [date] NULL,
	[dtpPrjStartDate] [date] NULL,
	[dtpPrjEndDate] [date] NULL,
	[rdbQty] [bit] NULL,
	[chkAmtIncTax] [bit] NULL,
	[txtHajezPercent] [money] NULL,
	[CrrentPC] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled1] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled2] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled3] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled4] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled5] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[ConrtCond] [text] COLLATE Arabic_CI_AS NULL,
	[ContActive] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[MaxDateEndDate] [date] NULL,
	[MaxExtNo] [int] NULL,
	[IsPrevDB] [bit] NULL,
 CONSTRAINT [PK_OwnerCotractNo] PRIMARY KEY CLUSTERED 
(
	[ContID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[OwnerCotractNo] ADD  CONSTRAINT [DF_OwnerCotractNo_IsPrevDB]  DEFAULT ((0)) FOR [IsPrevDB]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MKRPosInvoiceHeader](
	[InvoiceNo] [int] NULL,
	[InvoiceDate] [date] NULL,
	[InvoiceTime] [time](6) NULL,
	[PosUser] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Remarks] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[InvoiceStatus] [int] NULL,
	[Descount] [money] NULL,
	[QtyTotal] [money] NULL,
	[SubTotal] [money] NULL,
	[Tax] [money] NULL,
	[GenTotal] [money] NULL,
	[CashID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SalesID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RSalesID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DescounID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CashCastID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StockAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsSale] [bit] NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PayAmt] [money] NULL,
	[RetAmt] [money] NULL,
	[IsCashPay] [bit] NULL,
	[selectCost] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DefultPrice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxPercent] [money] NULL,
	[MerageRows] [bit] NULL,
	[PriceIncTax] [bit] NULL,
	[PnlPrd] [bit] NULL,
	[TaxCol] [bit] NULL,
	[UserCardNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[RerurnAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Loacalization] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TableID] [int] NULL,
	[TableIDToShow] [int] NULL,
	[OrderStatus] [int] NULL,
	[OrderRemarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_Descount]  DEFAULT ((0)) FOR [Descount]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_QtyTotal]  DEFAULT ((0)) FOR [QtyTotal]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_SubTotal]  DEFAULT ((0)) FOR [SubTotal]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_Tax]  DEFAULT ((0)) FOR [Tax]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_GenTotal]  DEFAULT ((0)) FOR [GenTotal]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_IsSale]  DEFAULT ((1)) FOR [IsSale]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_IsCashPay]  DEFAULT ((1)) FOR [IsCashPay]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_MerageRows]  DEFAULT ((1)) FOR [MerageRows]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_PnlPrd]  DEFAULT ((1)) FOR [PnlPrd]
ALTER TABLE [dbo].[MKRPosInvoiceHeader] ADD  CONSTRAINT [DF_MKRPosInvoiceHeader_TaxCol]  DEFAULT ((1)) FOR [TaxCol]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[GenDocSerial](
	[DocSerial] [decimal](18, 0) NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[BranchDBName](
	[ID] [int] NULL,
	[BranchDB] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[SelAsc] [bit] NULL,
	[SelRPT] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[BranchDBName] ADD  CONSTRAINT [DF_BranchDBName_SelAsc]  DEFAULT ((1)) FOR [SelAsc]
ALTER TABLE [dbo].[BranchDBName] ADD  CONSTRAINT [DF_BranchDBName_SelRPT]  DEFAULT ((1)) FOR [SelRPT]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[FastReportVoucher](
	[ID] [int] NULL,
	[Vocher] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[FastReportName1] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[FastReportName2] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[FastReportName3] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[book] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[BankList](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BankName] [nvarchar](100) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrPosRestOptions](
	[chkPrintReport] [bit] NULL,
	[chkShowOrder] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrPosRestOptions] ADD  CONSTRAINT [DF_MkrPosRestOptions_chkPrintReport]  DEFAULT ((0)) FOR [chkPrintReport]
ALTER TABLE [dbo].[MkrPosRestOptions] ADD  CONSTRAINT [DF_MkrPosRestOptions_chkShowOrder]  DEFAULT ((0)) FOR [chkShowOrder]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PrdRequestBook](
	[PruchBookNo] [int] NOT NULL,
	[PruchBookName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StartNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Document] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkRak] [bit] NULL,
	[chkRemarks] [bit] NULL,
	[Detels] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkQty2] [bit] NULL,
	[chkQty3] [bit] NULL,
	[Report] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ChkExpiryDate] [bit] NULL,
	[cmbDefulPrice] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
 CONSTRAINT [PK_PrdRequestBook] PRIMARY KEY CLUSTERED 
(
	[PruchBookNo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PrdRequestBook] ADD  CONSTRAINT [DF_PrdRequestBook_chkRak]  DEFAULT ((0)) FOR [chkRak]
ALTER TABLE [dbo].[PrdRequestBook] ADD  CONSTRAINT [DF_PrdRequestBook_chkRemarks]  DEFAULT ((0)) FOR [chkRemarks]
ALTER TABLE [dbo].[PrdRequestBook] ADD  CONSTRAINT [DF_PrdRequestBook_chkQty2]  DEFAULT ((0)) FOR [chkQty2]
ALTER TABLE [dbo].[PrdRequestBook] ADD  CONSTRAINT [DF_PrdRequestBook_chkQty3]  DEFAULT ((0)) FOR [chkQty3]
ALTER TABLE [dbo].[PrdRequestBook] ADD  CONSTRAINT [DF_PrdRequestBook_ChkExpiryDate]  DEFAULT ((0)) FOR [ChkExpiryDate]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrSyncSetup](
	[SyncType] [bit] NULL,
	[MainLicNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkBrunchToCenter] [bit] NULL,
	[txtBrunchTime] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkReadFromBrunch] [bit] NULL,
	[txtCenterTime] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CenterDbName] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[chkBrunchLicNo] [bit] NULL,
	[txtBrunchLicNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrSyncSetup] ADD  CONSTRAINT [DF_MkrSyncSetup_SyncType]  DEFAULT ((1)) FOR [SyncType]
ALTER TABLE [dbo].[MkrSyncSetup] ADD  CONSTRAINT [DF_MkrSyncSetup_chkBrunchToCenter]  DEFAULT ((0)) FOR [chkBrunchToCenter]
ALTER TABLE [dbo].[MkrSyncSetup] ADD  CONSTRAINT [DF_MkrSyncSetup_chkReadFromBrunch]  DEFAULT ((0)) FOR [chkReadFromBrunch]
ALTER TABLE [dbo].[MkrSyncSetup] ADD  CONSTRAINT [DF_MkrSyncSetup_chkBrunchLicNo]  DEFAULT ((0)) FOR [chkBrunchLicNo]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ExtractDetales](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[extractID] [int] NULL,
	[extractNo] [int] NULL,
	[WorkType] [nvarchar](900) COLLATE Arabic_CI_AS NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[LastQty] [money] NULL,
	[QtyInPeriod] [money] NULL,
	[NetQty] [money] NULL,
	[Price] [money] NULL,
	[NetValue] [money] NULL,
	[RowID] [int] NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CostSettingInVoucher](
	[VocherName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[BookNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ForceCostCenter] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[CostSettingInVoucher] ADD  CONSTRAINT [DF_CostSettingInVoucher_ForceCostCenter]  DEFAULT ((0)) FOR [ForceCostCenter]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PrjAsmName](
	[ID] [int] NULL,
	[AsmPrj] [nvarchar](200) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrPosOrderOptions](
	[ID] [int] NULL,
	[OrderStatus] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[IsTable] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrPosOrderOptions] ADD  CONSTRAINT [DF_MkrPosOrderOptions_IsTable]  DEFAULT ((0)) FOR [IsTable]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AccEntraceAscy](
	[AccEntraceID] [int] IDENTITY(1,1) NOT NULL,
	[InRecycle] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Debit] [money] NULL,
	[Credit] [money] NULL,
	[Deteles] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[Doc] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[AccDate] [date] NULL,
	[post] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[EntNo] [int] NULL,
	[EntID] [int] NULL,
	[RecNotNo] [int] NULL,
	[RecNotID] [int] NULL,
	[SalesNo] [int] NULL,
	[SalesID] [int] NULL,
	[Discount] [money] NULL,
	[PruchNo] [int] NULL,
	[PruchID] [int] NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Project] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PayNotNo] [int] NULL,
	[PayNotID] [int] NULL,
	[OtherAcc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Action] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[cash_no] [int] NULL,
	[cash_ID] [int] NULL,
	[cash] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CashOrder] [int] NULL,
	[CecqueINNo] [int] NULL,
	[CecqueINID] [int] NULL,
	[ChequeNO] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ChequeDate] [date] NULL,
	[OtherAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Isbank] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chequeState] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsChecque] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CecqueOutNo] [int] NULL,
	[CecqueOutID] [int] NULL,
	[CastBank] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ChecqueType] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccstatmentCheck] [bit] NULL,
	[FinalID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[isFinal] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[isNextFinal] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Final] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[ContNo] [int] NULL,
	[ContID] [int] NULL,
	[RowNumCont] [int] NULL,
	[PrdID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[QtyIn1] [money] NULL,
	[QtyIn2] [money] NULL,
	[QtyOut1] [money] NULL,
	[QtyOut2] [money] NULL,
	[PriceIn1] [money] NULL,
	[PriceIn2] [money] NULL,
	[PriceOut1] [money] NULL,
	[PriceOut2] [money] NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Stor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Qty1] [money] NULL,
	[Qty2] [money] NULL,
	[Price1] [money] NULL,
	[Price2] [money] NULL,
	[Total1] [money] NULL,
	[Total2] [money] NULL,
	[UnitIndex] [int] NULL,
	[AccBook] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StockBook] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[journal_reprtCheck] [bit] NULL,
	[OP] [decimal](18, 0) NULL,
	[Rak] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrjCheck] [bit] NULL,
	[CostCheck] [bit] NULL,
	[CheqCheck] [bit] NULL,
	[CheqCheck1] [bit] NULL,
	[Remarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[DelyNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DelyDate] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CasrPrj] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AccID1] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[openStockID] [int] NULL,
	[SreturnID] [int] NULL,
	[SreturnNo] [int] NULL,
	[PreturnNo] [int] NULL,
	[PreturnID] [int] NULL,
	[AllEntCheck] [bit] NULL,
	[AllRecCheck] [bit] NULL,
	[AllPayCheck] [bit] NULL,
	[AllSalesCheck] [bit] NULL,
	[AlPruchCheck] [bit] NULL,
	[AllSreturnCheck] [bit] NULL,
	[AlPReturnCheck] [bit] NULL,
	[Qty3] [money] NULL,
	[QtyIn3] [money] NULL,
	[PriceIn3] [money] NULL,
	[QtyOut3] [money] NULL,
	[PriceOut3] [money] NULL,
	[OpenChicID] [int] NULL,
	[OpenChicNo] [int] NULL,
	[ChicDoc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[AlCashCheck] [bit] NULL,
	[STransferID] [int] NULL,
	[STransferNo] [int] NULL,
	[IsTransfer] [bit] NULL,
	[TaxFaxtor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxAmount] [money] NULL,
	[NetWTax] [money] NULL,
	[RowDescount] [money] NULL,
	[SNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Loacalization] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SupVocherNo] [int] NULL,
	[TaxType] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrdTyp] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[LoacalizationInEnt] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DebitNotID] [int] NULL,
	[DebitNotNo] [int] NULL,
	[CreditNotID] [int] NULL,
	[CreditNotNo] [int] NULL,
	[StockInID] [int] NULL,
	[StockInNo] [int] NULL,
	[StockOutID] [int] NULL,
	[StockOutNo] [int] NULL,
	[ServiceVoucheID] [int] NULL,
	[ServiceVoucheNo] [int] NULL,
	[ProdectionID] [int] NULL,
	[ProdectionNo] [int] NULL,
	[AllChicInCheck] [bit] NULL,
	[AllChicOutCheck] [bit] NULL,
	[Apply] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[PrdExpiryDate] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[otherJournalID] [int] NULL,
	[ClaimID] [int] NULL,
	[PrjPaymentNo] [int] NULL,
	[PrjPaymentID] [int] NULL,
	[AllCreditChk] [bit] NULL,
	[AllDebitChk] [bit] NULL,
	[SerialNumber] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsPrjPaymentTable] [bit] NULL,
	[CurrencyID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[DebitCurrency] [money] NULL,
	[CreditCurrency] [money] NULL,
	[CurrenctEq] [money] NULL,
	[InventorySettlemenID] [int] NULL,
	[InventorySettlemenNo] [int] NULL,
	[thQty] [money] NULL,
	[ActQty] [money] NULL,
	[thAmt] [money] NULL,
	[ActAmt] [money] NULL,
	[InventorySettlementQty2] [money] NULL,
	[InventorySettlementQty3] [money] NULL,
	[IsPurchaseSide] [bit] NULL,
	[IsSalesSide] [bit] NULL,
	[LoadType] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PriceCostSide] [money] NULL,
	[CrnPurchaseID] [int] NULL,
	[CrnPurchaseNo] [int] NULL,
	[CrnSalesID] [int] NULL,
	[CrnSalesNo] [int] NULL,
	[IsProdectionEnt] [bit] NULL,
	[DueDate] [date] NULL,
	[JournalVocherOP] [int] NULL,
	[AddedDate] [date] NULL,
	[AddedTime] [time](6) NULL,
	[AddedUser] [int] NULL,
	[EditDate] [date] NULL,
	[EditTime] [time](6) NULL,
	[EditUser] [int] NULL,
	[DeletedDate] [date] NULL,
	[DeletedTime] [time](6) NULL,
	[DeletedUser] [int] NULL,
	[RemarksExtendChicDate] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[DateExtendChicDate] [date] NULL,
	[DatabaseNameAscy] [nvarchar](100) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Debit]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Credit]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'no') FOR [Isbank]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'حصّل') FOR [chequeState]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'no') FOR [IsChecque]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AccstatmentCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'No') FOR [isFinal]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'No') FOR [isNextFinal]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT (N'not') FOR [Final]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyIn1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyIn2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyOut1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyOut2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceIn1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceIn2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceOut1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceOut2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Qty1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Qty2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Price1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Price2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Total1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Total2]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [UnitIndex]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [journal_reprtCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PrjCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [CostCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [CheqCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [CheqCheck1]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllEntCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllRecCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllPayCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllSalesCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [Qty3]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyIn3]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceIn3]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [QtyOut3]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [PriceOut3]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [IsTransfer]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((1)) FOR [Loacalization]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((1)) FOR [LoacalizationInEnt]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllChicInCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [AllChicOutCheck]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ('') FOR [SerialNumber]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [IsPrjPaymentTable]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [DebitCurrency]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [CreditCurrency]
ALTER TABLE [dbo].[AccEntraceAscy] ADD  DEFAULT ((0)) FOR [IsProdectionEnt]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PrdRequestNo](
	[PruchNo] [int] NULL,
	[PruchDate] [date] NULL,
	[Remarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PruchBookNo] [int] NULL,
	[PruchID] [int] NOT NULL,
	[Inrecyle] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SrcStor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TrgStor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[BookName] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[StartNo] [int] NULL,
	[AllStransferCheked] [bit] NULL,
	[CrrentPC] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
 CONSTRAINT [PK_PrdRequestNo] PRIMARY KEY CLUSTERED 
(
	[PruchID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ExtractNo](
	[extractID] [int] NOT NULL,
	[extractNo] [int] NULL,
	[ContID] [int] NULL,
	[extractDate] [date] NULL,
	[StartDate] [date] NULL,
	[EndDate] [date] NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SubContExtractNo] [int] NULL,
	[ContractorID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[HajezID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrj] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[CrrentPC] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[txtRemarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[Detales] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled1] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled2] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled3] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled4] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled5] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[rdbQty] [bit] NULL,
	[chkAmtIncTax] [bit] NULL,
	[txtHajezPercent] [money] NULL,
	[post] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[lblNet] [money] NULL,
	[lblTotal] [money] NULL,
	[lblHajezTotal] [money] NULL,
	[lblTaxTotal] [money] NULL,
	[chkWithoutTax] [bit] NULL,
	[DescAmt] [money] NULL,
	[DescDetailes] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[PayDown] [money] NULL,
	[ContractorNet] [money] NULL,
	[JournalVocherOP] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsFree] [bit] NULL,
 CONSTRAINT [PK_ExtractNo] PRIMARY KEY CLUSTERED 
(
	[extractID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ExtractNo] ADD  CONSTRAINT [DF_ExtractNo_post]  DEFAULT (N'غير مرحل') FOR [post]
ALTER TABLE [dbo].[ExtractNo] ADD  CONSTRAINT [DF_ExtractNo_chkWithoutTax]  DEFAULT ((0)) FOR [chkWithoutTax]
ALTER TABLE [dbo].[ExtractNo] ADD  CONSTRAINT [DF_ExtractNo_IsFree]  DEFAULT ((0)) FOR [IsFree]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PrdRecuestDetales](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[RecuestNo] [int] NULL,
	[PrdID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[QtyOut1] [money] NULL,
	[QtyOut2] [money] NULL,
	[QtyOut3] [money] NULL,
	[Price] [money] NULL,
	[StockBook] [int] NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Remarks] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Invoiced] [bit] NULL,
	[Deteles] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[SelUnitIndex] [int] NULL,
 CONSTRAINT [PK_PrdRecuestDetales] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PrdRecuestDetales] ADD  CONSTRAINT [DF_PrdRecuestDetales_Invoiced]  DEFAULT ((0)) FOR [Invoiced]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SubContractorNo](
	[ContID] [int] NOT NULL,
	[ContNo] [int] NULL,
	[ContractorID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[HajezID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrj] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[txtWorType] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtRemarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[dtpContDate] [date] NULL,
	[dtpContStartDate] [date] NULL,
	[dtpContEndDate] [date] NULL,
	[dtpPrjStartDate] [date] NULL,
	[dtpPrjEndDate] [date] NULL,
	[rdbQty] [bit] NULL,
	[chkAmtIncTax] [bit] NULL,
	[txtHajezPercent] [money] NULL,
	[CrrentPC] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled1] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled2] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled3] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled4] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled5] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[ConrtCond] [text] COLLATE Arabic_CI_AS NULL,
	[txtContLicNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtContFacilityNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtContLabNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[dtpContLicExpire] [date] NULL,
	[ContActive] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[MaxDateEndDate] [date] NULL,
	[MaxExtNo] [int] NULL,
	[IsPrevDB] [bit] NULL,
 CONSTRAINT [PK_SubContraxtorNo] PRIMARY KEY CLUSTERED 
(
	[ContID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[SubContractorNo] ADD  CONSTRAINT [DF_SubContractorNo_IsPrevDB]  DEFAULT ((0)) FOR [IsPrevDB]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrSyncBrunchLicNo](
	[ID] [int] NULL,
	[LicNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[BrunchName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[IsActive] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrSyncBrunchLicNo] ADD  CONSTRAINT [DF_MkrSyncBrunchLicNo_IsActive]  DEFAULT ((0)) FOR [IsActive]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DataMerrorSet](
	[SenderMode] [bit] NULL,
	[S_SenderDataeBase] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[S_ReceverDataBase] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[ReceverLicNo] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[R_ReceverDataBase] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[R_SenderDataeBase] [nvarchar](200) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MizanPrinterHeader](
	[ID] [int] NULL,
	[MizanBarcod] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OwnerContractExtractSetting](
	[TaxID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxPercent] [money] NULL,
	[Orgin] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[TaxType] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[MainSubAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkErasCon] [bit] NULL,
	[rtbDifCond] [text] COLLATE Arabic_CI_AS NULL,
	[chkEnglish] [bit] NULL,
	[TaxOnIncoming] [bit] NULL,
	[ErasPostInfo] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[OwnerContractExtractSetting] ADD  CONSTRAINT [DF_OwnerContractExtractSetting_chkErasCon]  DEFAULT ((0)) FOR [chkErasCon]
ALTER TABLE [dbo].[OwnerContractExtractSetting] ADD  CONSTRAINT [DF_OwnerContractExtractSetting_chkEnglish]  DEFAULT ((0)) FOR [chkEnglish]
ALTER TABLE [dbo].[OwnerContractExtractSetting] ADD  CONSTRAINT [DF_OwnerContractExtractSetting_TaxOnIncoming]  DEFAULT ((1)) FOR [TaxOnIncoming]
ALTER TABLE [dbo].[OwnerContractExtractSetting] ADD  CONSTRAINT [DF_OwnerContractExtractSetting_ErasPostInfo]  DEFAULT ((0)) FOR [ErasPostInfo]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MizanPrinterDetales](
	[MizanID] [int] NULL,
	[PrdID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Qty] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SupContractorDetales](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ContID] [int] NULL,
	[ContNo] [int] NULL,
	[RowID] [int] NULL,
	[WorkType] [nvarchar](900) COLLATE Arabic_CI_AS NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[price] [money] NULL,
	[Remarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[LastQty] [money] NULL,
	[QtyInPeriod] [money] NULL,
	[NetQty] [money] NULL,
	[NetValue] [money] NULL,
	[PrevRowID] [int] NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OwnerExtractNo](
	[extractID] [int] NOT NULL,
	[extractNo] [int] NULL,
	[ContID] [int] NULL,
	[extractDate] [date] NULL,
	[StartDate] [date] NULL,
	[EndDate] [date] NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[SubContExtractNo] [int] NULL,
	[ContractorID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[HajezID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtPrj] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[CrrentPC] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[txtRemarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[Detales] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled1] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled2] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled3] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled4] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[txtPrintfieled5] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[CostID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[rdbQty] [bit] NULL,
	[chkAmtIncTax] [bit] NULL,
	[txtHajezPercent] [money] NULL,
	[post] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[lblNet] [money] NULL,
	[lblTotal] [money] NULL,
	[lblHajezTotal] [money] NULL,
	[lblTaxTotal] [money] NULL,
	[chkWithoutTax] [bit] NULL,
	[DescAmt] [money] NULL,
	[DescDetailes] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[PayDown] [money] NULL,
	[ContractorNet] [money] NULL,
	[JournalVocherOP] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[IsFree] [bit] NULL,
	[IncomingAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostTaxAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostTaxID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[CostTaxDetales] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
 CONSTRAINT [PK_OwnerExtractNo] PRIMARY KEY CLUSTERED 
(
	[extractID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[OwnerExtractNo] ADD  CONSTRAINT [DF_OwnerExtractNo_post]  DEFAULT (N'غير مرحل') FOR [post]
ALTER TABLE [dbo].[OwnerExtractNo] ADD  CONSTRAINT [DF_OwnerExtractNo_chkWithoutTax]  DEFAULT ((0)) FOR [chkWithoutTax]
ALTER TABLE [dbo].[OwnerExtractNo] ADD  CONSTRAINT [DF_OwnerExtractNo_IsFree]  DEFAULT ((0)) FOR [IsFree]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AccEntraceTemp](
	[AccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[PrdID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[Debit] [money] NULL,
	[Credit] [money] NULL,
	[Detales] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[Doc] [nvarchar](50) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]


GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MkrRestPrinterAndReport](
	[ID] [int] NULL,
	[SecName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[PrinterName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[ReportName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[IsActive] [bit] NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MkrRestPrinterAndReport] ADD  CONSTRAINT [DF_MkrRestPrinterAndReport_IsActive]  DEFAULT ((0)) FOR [IsActive]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MKRPosTableName](
	[TableID] [int] IDENTITY(1,1) NOT NULL,
	[GrpID] [int] NULL,
	[TableName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[IsRes] [bit] NULL,
	[ResName] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[ComeDate] [datetime] NULL,
	[PersCount] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[Remarks] [nvarchar](100) COLLATE Arabic_CI_AS NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[MKRPosTableName] ADD  CONSTRAINT [DF_MKRPosTableName_IsRes]  DEFAULT ((0)) FOR [IsRes]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SubContractExtractSetting](
	[TaxID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxPercent] [money] NULL,
	[Orgin] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[TaxType] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[MainSubAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[MainHajezAccID] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[chkCreateHajezAcc] [bit] NULL,
	[chkErasCon] [bit] NULL,
	[txtOwnerLicNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtOnerFacilityNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[txtOwnerLabNo] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[dtpOwnerLicExpire] [date] NULL,
	[rtbDifCond] [text] COLLATE Arabic_CI_AS NULL,
	[OwnerActive] [nvarchar](100) COLLATE Arabic_CI_AS NULL,
	[chkEnglish] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[SubContractExtractSetting] ADD  CONSTRAINT [DF_SubContractExtractSetting_chkCreateHajezAcc]  DEFAULT ((1)) FOR [chkCreateHajezAcc]
ALTER TABLE [dbo].[SubContractExtractSetting] ADD  CONSTRAINT [DF_SubContractExtractSetting_chkErasCo]  DEFAULT ((0)) FOR [chkErasCon]
ALTER TABLE [dbo].[SubContractExtractSetting] ADD  CONSTRAINT [DF_SubContractExtractSetting_chkEnglish]  DEFAULT ((0)) FOR [chkEnglish]

GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OwnerCotractDeatles](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ContID] [int] NULL,
	[ContNo] [int] NULL,
	[RowID] [int] NULL,
	[WorkType] [nvarchar](900) COLLATE Arabic_CI_AS NULL,
	[Unit] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[price] [money] NULL,
	[Remarks] [nvarchar](200) COLLATE Arabic_CI_AS NULL,
	[LastQty] [money] NULL,
	[QtyInPeriod] [money] NULL,
	[NetQty] [money] NULL,
	[NetValue] [money] NULL,
	[CurrentValue] [money] NULL,
	[TaxFactor] [nvarchar](50) COLLATE Arabic_CI_AS NULL,
	[TaxValue] [money] NULL,
	[TotalIncTax] [money] NULL,
	[PrevRowID] [int] NULL
) ON [PRIMARY]


GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO

GO
